function out = fct_value_functions(parameters)

    % this script computes the simple model and illustrates its comparative
    % statics
    
    mm_mat = fieldnames(parameters);    
    for ii = 1 : length(mm_mat)
        eval([cell2mat(mm_mat(ii)) '= parameters.(cell2mat(mm_mat(ii)));'])
    end

    %%%% solve for the roots
    bar_lambda = (-bar_mu - sqrt(bar_mu^2 + 2*rho*bar_sigma^2))/bar_sigma^2;
    til_lambda = (-til_mu + sqrt(til_mu^2 + 2*rho*til_sigma^2))/til_sigma^2;
    
    xmed = log(b/rho) + log(rho-bar_mu-bar_sigma^2/2);
    
    % compute value function for arbitray thresholds:
    
    und_x=xmed-0.1;
    bar_x=xmed+0.1;
    
    [xsolv] = fsolve(@(x) fct_eval_barx_undx(x,rho,bar_mu,bar_sigma,bar_lambda,til_lambda,ppsi,b),[und_x bar_x]) ;
    
    und_x=xsolv(1);
    bar_x=xsolv(2);
    
    [ e  n ] = fct_solve_en(bar_x,und_x,rho,bar_mu,bar_sigma,bar_lambda,til_lambda,ppsi,b) ;
    
    xvec=[und_x-(bar_x-und_x):(bar_x-und_x)/20:bar_x+(bar_x-und_x)];
    
    
    %
    Nvec = b/rho + n*exp(til_lambda*xvec) ;
    Evec = exp(xvec)/(rho-bar_mu-bar_sigma^2/2) + e*exp(bar_lambda*xvec);
    
    %
    ie=1;
    in=1;
    
    for i=1:length(xvec);
        x=xvec(i);
        if x <= und_x
            xn(in)=x;
            Vn_vec(in) = Nvec(i);
            in=in+1;
        elseif und_x < x & x <= bar_x
            xn(in)=x;
            Vn_vec(in) = Nvec(i);
            in=in+1;
            xe(ie)=x;
            Ve_vec(ie) = Evec(i);
            ie=ie+1;
        elseif x > bar_x
            xe(ie)=x;
            Ve_vec(ie) = Evec(i);
            ie=ie+1;
        end
    end
    
    yline = [20:0.5:45];
    
    figure(12); hold on;
    plot(xe,Ve_vec,'r-','Linewidth',1.5)
    plot(xn,Vn_vec,'b-','Linewidth',1.5)
    plot(xvec,exp(xvec)/(rho-bar_mu-bar_sigma^2/2),'r--','Linewidth',1.5)
    plot(und_x*ones(length(yline),1),yline, 'color', [.5 .5 .5])
    plot(xvec,ones(1,length(xvec))*b/rho,'b--','Linewidth',1.5)
    plot(bar_x*ones(length(yline),1),yline, 'color', [.5 .5 .5])
    le=legend('employment value $E(\omega)$','always employed','non-employed value $N(\omega)$','never-employed');
    set(le,'Interpreter','Latex','Fontsize',14,'Location','NorthWest');
    legend boxoff;
    xlim([-1.2 -0.4])
    ylim([20 45])
    xl=xlabel('net benefit from employment $\omega$');
    ylabel('value')
    set(xl,'Interpreter','Latex');
    t1=text(und_x,b/rho*.95,'$\underline{\omega}$');
    t2=text(bar_x,b/rho*.95,'$\bar{\omega}$');
    set(t1,'Interpreter','Latex','Fontsize',16);
    set(t2,'Interpreter','Latex','Fontsize',16);
    tl = title('Figure 12: Value functions $E(\omega)$ and $N(\omega)$');
    set(tl,'Interpreter','Latex','Fontsize',12);

    xe = round(xe',5);
    Ve = round(Ve_vec',5);
    tab = table(xe,Ve);
    writetable(tab,'out_value_fun_emp_RP.txt','Delimiter',' ')
    
    xn = round(xn',5);
    Vn = round(Vn_vec',5);
    tab = table(xn,Vn);
    writetable(tab,'out_value_fun_unemp_RP.txt','Delimiter',' ')

    xea = round(xvec',5);
    Vea = round(exp(xvec')/(rho-bar_mu-bar_sigma^2/2),5);    
    Vne = round(ones(length(xvec),1)*b/rho,5);
    tab = table(xea,Vea,Vne);
    writetable(tab,'out_value_fun_alwaysemp_non_RP.txt','Delimiter',' ')


    out = 1;

return
